let monitoring = false;
let checkInterval = null;

// Initialize
chrome.storage.local.get(['monitoring'], (result) => {
  monitoring = result.monitoring || false;
  if (monitoring) startMonitoring();
});

// Listen for messages
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "toggle") {
    monitoring = request.state;
    if (monitoring) startMonitoring();
    else stopMonitoring();
  }
});

function startMonitoring() {
  console.log("DMV Sniper: Monitoring started.");
  if (checkInterval) clearInterval(checkInterval);
  
  // Check immediately then every 30s
  checkSlots();
  checkInterval = setInterval(checkSlots, 30000); // 30 seconds refresh
}

function stopMonitoring() {
  console.log("DMV Sniper: Monitoring stopped.");
  if (checkInterval) clearInterval(checkInterval);
}

function checkSlots() {
  if (!monitoring) return;

  // Heuristic: Look for "No appointments" text
  const bodyText = document.body.innerText;
  const failurePhrases = [
    "No appointments available",
    "No time slots",
    "No availability"
  ];
  
  const foundFailure = failurePhrases.some(phrase => bodyText.includes(phrase));

  if (foundFailure) {
    console.log("DMV Sniper: No slots. Refreshing in random 20-40s...");
    const delay = 20000 + Math.random() * 20000;
    setTimeout(() => {
      if (monitoring) window.location.reload();
    }, delay);
  } else {
    // Potential Success! (Or we are on a different page)
    // We only alert if we are definitely on a scheduler page (heuristic)
    if (bodyText.includes("Time") || bodyText.includes("Select")) {
        console.log("DMV Sniper: POSSIBLE SLOT FOUND!");
        alert("DMV SNIPER ALERT: Check the screen! Possible slot found.");
        stopMonitoring();
        chrome.storage.local.set({ monitoring: false });
    }
  }
}
