document.addEventListener('DOMContentLoaded', () => {
  const btn = document.getElementById('toggleBtn');
  const statusDiv = document.getElementById('status');

  // Load state
  chrome.storage.local.get(['monitoring'], (result) => {
    updateUI(result.monitoring);
  });

  btn.addEventListener('click', () => {
    chrome.storage.local.get(['monitoring'], (result) => {
      const newState = !result.monitoring;
      chrome.storage.local.set({ monitoring: newState }, () => {
        updateUI(newState);
        // Send message to content script
        chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
          if (tabs[0]?.id) {
            chrome.tabs.sendMessage(tabs[0].id, { action: "toggle", state: newState });
          }
        });
      });
    });
  });

  function updateUI(isMonitoring) {
    if (isMonitoring) {
      btn.textContent = "Stop Monitoring";
      btn.classList.add('stop');
      statusDiv.textContent = "Status: Monitoring active...";
      statusDiv.style.color = "green";
    } else {
      btn.textContent = "Start Monitoring";
      btn.classList.remove('stop');
      statusDiv.textContent = "Status: Idle";
      statusDiv.style.color = "#666";
    }
  }
});
